#!/bin/ksh
#!/bin/ksh -xv
#
# $Id: send2helpsys.sh,v 1.1 2023/03/27 16:07:05 root Exp $
#
# The following code is Confidential and is covered by the installation license
# (c) Copyright Fortra, LLC. and its group of companies.
#
#&& Send the pninfo file to ftp.mpginc.net as user capplan
#
#@ Requires ftp command
#
#& Requires CompanyName.  
#& Syntax:
#&    ./send2helpsys.sh CompanyName 
#& Gets the directory from /etc/pn.conf 
#
# Original name was sendpinfo2mpg.sh or sendpinfo2hsllc.sh   
#
echo "Running `grep "\$\I\d\:" ${0} | awk '{print $3,$4,$5,$6}' ` "
#
jhelp () {
echo "##########
Syntax:
      ./send2helpsys.sh (-m) CompanyName 
      -m is to send pninfo_multiple file
##########"
}

#Confirm that ftp command is available
jftp=`which ftp 2>$1 > /dev/null`
jftpchk=${?}

if [ "x1x" = "x${jftpchk}x" ] ; then
   echo "##########"
   echo "Command ftp is not available" 
   jhelp
   echo "Exiting" ; exit
fi

if [ "xx" = "x${1}x" ] && [ "xx" = "x${2}x" ] ; then
   jhelp
   echo "Exiting" ; exit
fi

if [ "x${1}x" != "x-mx" ]; then
   # If -m is not specified will use $0 for CompanyName 
   echo "If -m is not specified will use \$0 for CompanyName" 
   . /etc/pn.conf
   if [ ! -s $nminst ]; then
      jhelp
      echo "Exiting" ; exit
   fi
   cd ${nminst}
   jcomp=`echo "$*" | sed s,\ ,\_,g`
else
   # If -m is specified will use all but $1 for CompanyName 
   echo " If -m is specified will use all \$1 for CompanyName "
   echo " and will send a pninfo file from the current directory. "
   jcomp=`echo "$*" | cut -f 2- | sed s,\ ,\_,g`
fi
echo " (${jcomp}) "
# jcname=`echo "$jcomp" | awk -F@ '{print $1}'`
# jcweb=`echo "$jcomp" | awk -F@ '{print $2}'`

# jdirname=`echo $jcweb | tr '.' '_'` 
echo "Sending pninfo file from ($jcomp) to user capplan at ftp.mpginc.net"

jpninfofile=`ls -1tr pninfo* | tail -1`
# echo "Remove later, exiting!"; exit 1

# echo "( ${jpninfofile} )"
jtemp_user="${jcomp}_${jpninfofile}"
# echo "${pninfofile} from $jcomp"
# echo "( ${jtemp_user} )"
if [ -s /etc/pn.conf ] && [ -s ${jpninfofile} ]  ; then
   echo "Sending (${jpninfofile}) from (${jcomp}) user capplan at ftp.mpginc.net"
ftp -n <<-jamjam
open ftp.mpginc.net
user capplan powernav
binary
put ${jpninfofile} ${jtemp_user}
dir ${jtemp_user}
quit
jamjam

else
   echo " /etc/pn.conf and ${jpninfofile} all have to exist."
fi

#& ###################
#& Sample Run
#& ###################
#& root #  ./send2helpsys.sh
#& Running send2helpsys.sh,v 1.2 2017/08/23 01:34:29
#& Sending (pninfo.hostname.systemtype.tar.gz) to user capplan at ftp.mpginc.net
#& Interactive mode off.
#& -rw-r--r--   1 capplan  capplan   4674514 Aug 23 01:45 pninfo.hostname.systemtype.tar.gz

